(function() {
    'use strict';

    if(window.NodeList && !NodeList.prototype.forEach) {
        NodeList.prototype.forEach = Array.prototype.forEach;
      }
      if(window.HTMLCollection && !HTMLCollection.prototype.forEach) {
        HTMLCollection.prototype.forEach = Array.prototype.forEach;
      }

    function handleToggle(event) {
        const toggleButton = event.target;
        const idToToggle = toggleButton.getAttribute('data-toggle')
        const elementToToggle = document.getElementById(idToToggle)

        if (elementToToggle === null) return;

        const isClosed = toggleButton.getAttribute('aria-expanded') === "false"

        if (isClosed) {
            elementToToggle.removeAttribute('hidden')
            toggleButton.setAttribute('aria-expanded', 'true')
        } else {
            elementToToggle.setAttribute('hidden', '')
            toggleButton.setAttribute('aria-expanded', 'false')
        }
    }

    window.addEventListener('load', function() {
        const toggleButtons = document.querySelectorAll('[data-toggle]')
        toggleButtons.forEach(function(toggleButton) {
            toggleButton.addEventListener('click', handleToggle)
        })
    })


})();